import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/route/route.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/controller/withdraw/withdraw_money_controller.dart';
import 'package:viserpay_agent/data/repo/withdraw/withdraw_money_repo.dart';
import 'package:viserpay_agent/data/services/api_service.dart';
import 'package:viserpay_agent/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:viserpay_agent/view/components/custom_loader/custom_loader.dart';
import 'package:viserpay_agent/view/components/no_data.dart';
import 'package:viserpay_agent/view/screens/withdrawals/withdraw_money/widget/withdraw_money_bottom_sheet.dart';
import 'package:viserpay_agent/view/screens/withdrawals/withdraw_money/widget/withdraw_money_card.dart';

import '../../../../core/utils/style.dart';

class WithdrawMoneyScreen extends StatefulWidget {
  const WithdrawMoneyScreen({super.key});

  @override
  State<WithdrawMoneyScreen> createState() => _WithdrawMoneyScreenState();
}

class _WithdrawMoneyScreenState extends State<WithdrawMoneyScreen> {
  final ScrollController scrollController = ScrollController();
  void scrollListener() {
    if (scrollController.position.pixels == scrollController.position.maxScrollExtent) {
      if (Get.find<WithdrawMoneyController>().hasNext()) {
        Get.find<WithdrawMoneyController>().loadData();
      }
    }
  }

  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(WithdrawMoneyRepo(apiClient: Get.find()));
    final controller = Get.put(WithdrawMoneyController(withdrawMoneyRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.initialData();
      scrollController.addListener(scrollListener);
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<WithdrawMoneyController>(
      builder: (controller) => SafeArea(
        child: Scaffold(
          backgroundColor: MyColor.screenBgColor,
          appBar: CustomAppBar(
            elevation: 0,
            title: MyStrings.withdrawMoney.tr,
            isTitleCenter: false,
            action: [
              Padding(
                padding: const EdgeInsets.all(Dimensions.space8),
                child: OutlinedButton(
                    style: OutlinedButton.styleFrom(
                      side: const BorderSide(width: 1.0, color: MyColor.primaryColor),
                    ),
                    onPressed: () {
                      Get.toNamed(RouteHelper.withdrawMethodScreen)?.then((value) => {controller.initialData()});
                    },
                    child: Text(
                      "+ ${MyStrings.addMethod.tr}",
                      style: regularDefault.copyWith(color: MyColor.primaryColor),
                    )),
              )
            ],
          ),
          body: controller.isLoading
              ? const CustomLoader()
              : controller.withdrawMoneyList.isEmpty && controller.isLoading == false
                  ? Center(
                      child: NoDataWidget(
                        noDataText: MyStrings.withdrawMethodEmptyMsg.tr,
                      ),
                    )
                  : RefreshIndicator(
                      backgroundColor: MyColor.colorWhite,
                      color: MyColor.primaryColor,
                      onRefresh: () async {
                        controller.initialData(); //
                      },
                      child: SingleChildScrollView(
                        physics: const AlwaysScrollableScrollPhysics(parent: ClampingScrollPhysics()),
                        padding: Dimensions.screenPaddingHV,
                        child: ListView.separated(
                            shrinkWrap: true,
                            padding: EdgeInsets.zero,
                            scrollDirection: Axis.vertical,
                            physics: const NeverScrollableScrollPhysics(),
                            itemCount: controller.withdrawMoneyList.length + 1,
                            separatorBuilder: (context, index) => const SizedBox(height: Dimensions.space10 + 2),
                            itemBuilder: (context, index) {
                              if (controller.withdrawMoneyList.length == index) {
                                return controller.hasNext() ? const CustomLoader(isPagination: true) : const SizedBox();
                              }

                              return WithdrawMoneyCard(
                                index: index,
                                press: () {
                                  controller.amountController.text = "";
                                  CustomBottomSheet(child: WithdrawMoneyBottomSheet(index: index)).customBottomSheet(context);
                                },
                              );
                            }),
                      ),
                    ),
        ),
      ),
    );
  }
}
